estadoGlobal = {

   // cantidaddecc:cantidaddecc,

    configuracion: {

        local: '003',//obtenerParametroUsuario('localID', ''), //no hay un valor por default definido,le pondré ''

        cantidadDecimales: {

            montos: {

                general: 3,

                totales: 2

            },

            cantidades: 2,

            tipoCambio: 3

        },

        tipoCambio: {

            venta: 3,//obtenerParametroPorKey('tipoCambio', 'venta', 0),

            mercado: 3.1//obtenerParametroPorKey('tipoCambio', 'compra', 0)

        },

        moneda: Constantes.Moneda.Sol.INICIAL,//obtenerParametro('moneda', Constantes.Moneda.Sol.INICIAL),

        vendedor: 'V0022',//obtenerParametroUsuario('vendedorID', ''),

        vendedorSeraDefinidoPorElCliente: 1,//obtenerParametro('GetVendedorFicha', 1), //no hay un valor por default definido,le pondré 1

        igv: 18,//obtenerParametro('TasaIgv', 0),

        precioIncluyeIgv: 1,//obtenerParametro('PrecioIncluyeIgv', 0),

        controlStock: 0//obtenerParametro('CtrlStock_PreVenta', 0)

    },

    agGrid: {

        configuracion: {

            defaultColDef: {

                sortable: true,

                filter: true,

                resizable: true

            },

            localeText: {

                page: 'Página',

                to: 'a',

                of: 'de',

                selectAll: 'Seleccionar todo',

                searchOoo: 'Buscar...',

                filterOoo: 'Filtrar...',

                noRowsToShow: 'No hay registros',

                pinColumn: 'Fijar columna',

                autosizeThiscolumn: 'Autoajustar esta columna',

                autosizeAllColumns: 'Autoajustar todas las columnas',

                resetColumns: 'Resetear',

                pinLeft: 'Fijar a la izquierda',

                pinRight: 'Fijar a la derecha',

                noPin: 'No fijar',

                copy: 'Copiar',

                ctrlC: 'ctrl + C',

                paste: 'Pegar',

                ctrlV: 'ctrl + V'

            },

            excelStyles: [

                {

                    id: 'header', //RESERVADO

                    interior: {

                        color: '#3c8dbc',

                        pattern: 'Solid'

                    },

                    borders: {

                        borderBottom: {

                            color: '#000000',

                            lineStyle: 'Continuous',

                            weight: 2

                        },

                        borderLeft: {

                            color: '#000000',

                            lineStyle: 'Continuous',

                            weight: 1

                        },

                        borderRight: {

                            color: '#000000',

                            lineStyle: 'Continuous',

                            weight: 1

                        },

                        borderTop: {

                            color: '#000000',

                            lineStyle: 'Continuous',

                            weight: 1

                        }

                    },

                    font: {

                        color: '#ffffff',

                        size: 12

                    }

                },

                {

                    id: "excel-datos",

                    borders: {

                        borderBottom: {

                            color: "#000000", lineStyle: 'Continuous', weight: 1

                        },

                        borderLeft: {

                            color: "#000000", lineStyle: 'Continuous', weight: 1

                        },

                        borderRight: {

                            color: "#000000", lineStyle: 'Continuous', weight: 1

                        },

                        borderTop: {

                            color: "#000000", lineStyle: 'Continuous', weight: 1

                        }

                    },

                    font: {

                        size: 10

                    }

                },

               

            ],

            contextMenuItems: {

                iconoAprobar: '<img src="../../images/aprobar.png"/>',

                iconoAnularAprobar: '<img src="../../images/deshacer.png"/>'

            },

            rowClassRules: {

                'alter-background': (params) => {

                    var indice = params.rowIndex;

                    var esPar = false;



                    esPar = indice === 0 ? true : indice % 2 === 0 ? true : false;



                    return esPar;

                }

            },

            pagination: true

        }

    }

};



//AG GRID

function inicializarAgGrid($divTabla, configuracion) {

    new agGrid.Grid($divTabla, configuracion);

    configuracion.api.setRowData(configuracion.datos);



    if (!configuracion.horizontalScroll && configuracion.horizontalScroll !== undefined) {

        $('.ag-body-horizontal-scroll-viewport').css('display', 'none');

        $('.ag-body-horizontal-scroll').css('display', 'none');

    }

}



function actualizarTodosLosDatosTabla(data, configuracion) {

    configuracion.api.setRowData(data);

}

//



//Define rutas hacia el servidor

function definirRutas() {

    $('#paths a').each(function (i, $iterable) {

        var $a = $($iterable);

        var idArreglo = $a.attr('id').split('-');

        var keyPadre = idArreglo[1];

        var key = '';



        idArreglo.forEach((item, i) => {

            if (i === 2) {

                key += item;

            }

            else if (i > 2) {

                var primeraLetraMayuscula = item.substr(0, 1).toUpperCase();

                var restoPalabra = item.substr(1);

                key += `${primeraLetraMayuscula}${restoPalabra}`;

            }

        });



        estado.ruta[keyPadre][key] = reemplazarSlashAsciiPorSlash($a.attr('href'));

    });



    $('#global-paths a').each(function (i, $iterable) {

        var $a = $($iterable);

        var idArreglo = $a.attr('id').split('-');

        var keyPadre = idArreglo[1];

        var key = '';



        idArreglo.forEach((item, i) => {

            if (i === 2) {

                key += item;

            }

            else if (i > 2) {

                var primeraLetraMayuscula = item.substr(0, 1).toUpperCase();

                var restoPalabra = item.substr(1);

                key += `${primeraLetraMayuscula}${restoPalabra}`;

            }

        });



        estadoGlobal.ruta[keyPadre][key] = reemplazarSlashAsciiPorSlash($a.attr('href'));

    });

}



//Reemplaza carácteres por slash

function reemplazarSlashAsciiPorSlash(url) {

    return url.replace(/%7B/g, "{").replace(/%7D/g, "}");

}



//Mostrar carga de datos

function mostrarLoader() {

    //$('#contenedor-total').addClass('blurry-div');

    //$('#loader-wrapper').fadeIn();

}



//Esconder carga de datos

function esconderLoader() {

    ////setTimeout(() => {

    //$('#contenedor-total').removeClass('blurry-div');

    //$('body').css('padding-right', '');



    //$('#loader-wrapper').fadeOut();

    ////}, 100);

}



//Obtiene el objeto moneda basado en la inicial de la misma.

function obtenerMonedaPorInicial(inicial) {

    var resultado;



    switch (inicial) {

        case Constantes.Moneda.Sol.INICIAL:

            resultado = Constantes.Moneda.Sol;

            break;

        case Constantes.Moneda.Dolar.INICIAL:

            resultado = Constantes.Moneda.Dolar;

            break;

    }



    return resultado;

}



//Formatear decimales.

function formatearNumericos($contexto) {

    if (!$contexto) {

        $contexto = $(document);

    }



    var formatoNumericoMontos = estadoGlobal.configuracion.cantidadDecimales.montos.general;

    var formatoNumericoTotales = estadoGlobal.configuracion.cantidadDecimales.montos.totales;

    var formatoNumerioCantidades = estadoGlobal.configuracion.cantidadDecimales.cantidades;

    var formatoNumerioTipoCambio = estadoGlobal.configuracion.cantidadDecimales.tipoCambio;



    var $formatoNumerico = $contexto.find('.formato-numerico');



    $.each($formatoNumerico, (i, $item) => {

        var numero;

        var numeroConFormato;



        var cantidadDecimales;

        if ($($item).hasClass('formato-numerico-montos')) {

            cantidadDecimales = formatoNumericoMontos;

        }

        else if ($($item).hasClass('formato-numerico-totales')) {

            cantidadDecimales = formatoNumericoTotales;

        }

        else if ($($item).hasClass('formato-numerico-cantidades')) {

            cantidadDecimales = formatoNumerioCantidades;

        }

        else if ($($item).hasClass('formato-numerico-tipo-cambio')) {

            cantidadDecimales = formatoNumerioTipoCambio;

        }



        switch ($item.tagName) {

            case Constantes.ElementoHtml.TD:

            case Constantes.ElementoHtml.SPAN:

            case Constantes.ElementoHtml.P:

                numero = parseFloat($($item).text());

                numeroConFormato = numero.toFixed(cantidadDecimales);

                $($item).text(numeroConFormato);

                break;

            case Constantes.ElementoHtml.INPUT:

                numero = parseFloat($($item).val());

                numeroConFormato = numero.toFixed(cantidadDecimales);

                $($item).val(numeroConFormato);

                break;

        }

    });

}



//Activar modal de confirmación.

function confirmacion(titulo, descripcion, accion) {

    var notificacionDeConfirmacion = Enumeradores.Notificacion.CONFIRMACION;

    notificacion(notificacionDeConfirmacion, titulo, descripcion, accion);

}



//Activar modal

function notificacion(tipo, titulo, descripcion, accion) {

    var alerta = Enumeradores.Notificacion.ALERTA;

    var confirmacion = Enumeradores.Notificacion.CONFIRMACION;

    var entrada = Enumeradores.Notificacion.ENTRADA;



    var $notificacion;



    switch (tipo) {

        case alerta:

            $notificacion = $('#alerta');

            break;

        case confirmacion:

            $notificacion = $('#confirmacion');

            break;

        case entrada:

            $notificacion = $('#entrada');

    }



    var $titulo = $notificacion.find('.titulo');

    var $descripcion = $notificacion.find('.descripcion');



    var $btnAceptar = $notificacion.find('.btn-aceptar');

    var $btnCancelar = $notificacion.find('.btn-cancelar');

    var $formulario = $notificacion.find('form');



    if (titulo) {

        $titulo.text(titulo);

    }

    if (descripcion) {

        $descripcion.text(descripcion);

    }



    if (accion) {

        if (accion.aceptar) {

            $btnAceptar.on('click', accion.aceptar);

            $btnCancelar.on('click', accion.cancelar);

        }

        else {

            switch (tipo) {

                case entrada:

                    $formulario.on('submit', function (e) {

                        e.preventDefault();

                        accion();

                        $notificacion.modal('hide');

                    });

                    break;

                case alerta:

                case confirmacion:

                    $btnAceptar.on('click', accion);

                    break;

            }

        }

    }



    $notificacion.modal();

}



//Formatea los decimales de una celda agGrid

function agGridFormatearDecimales(objetoCeldaAgGrid, cantidadDecimales) {

    var valorFormateado = null;



    if (objetoCeldaAgGrid.value || objetoCeldaAgGrid.value === 0) {

        var valorOriginal = parseFloat(objetoCeldaAgGrid.value);

        valorFormateado = valorOriginal.toFixed(cantidadDecimales);

    }



    return valorFormateado;

}



$(() => {

    definirRutas();

});

$(function() {

  'use strict';

  $('.js-menu-toggle').click(function(e) {

    var $this = $(this);

    

    if ( $('body').hasClass('show-sidebar') ) {
        $('body').removeClass('show-sidebar');
        $this.removeClass('active');
    } else {
        $('body').addClass('show-sidebar'); 
        $this.addClass('active');
    }

    e.preventDefault();

  });

  // click outisde offcanvas
    $(document).mouseup(function(e) {
    /*var container = $(".sidebar");
    if (!container.is(e.target) && container.has(e.target).length === 0) {
      if ( $('body').hasClass('show-sidebar') ) {
                $('body').removeClass('show-sidebar');
                $('body').find('.js-menu-toggle').removeClass('active');
            }
    }*/
    }); 

    

});